(*| 13:50 16/03/1996 *)
PROGRAM HexBin;

CONST
  HexAscii:ARRAY[0..15] OF CHAR = '0123456789ABCDEF';

  MaxBuff = $FFFE;

TYPE
  TString2 = STRING[2];
  TBBuff = ARRAY[0..MaxBuff] OF BYTE;
  PBBuff = ^TBBuff;

VAR
  BBuff: PBBuff;
  LoBuff, HiBuff: WORD;
  F1Name, F2Name,OffsetStr: STRING;
  I,LineNum,SaveHexWidth: INTEGER;
  CheckSum: WORD;
  Offset: WORD;
  ToHex,IntelFormat: BOOLEAN;
  Negative: BOOLEAN;

PROCEDURE UpString(VAR S: STRING);
VAR
  I: INTEGER;
BEGIN
  FOR I := 1 TO Length(S) DO
    S[I] := UpCase(S[I]);
END;  { UpString }

FUNCTION HexWordStr(W: WORD): STRING;
BEGIN
  HexWordStr := HexAscii[(Hi(W) SHR 4) AND $F] + HexAscii[Hi(W) AND $F]
                + HexAscii[(W SHR 4) AND $F] + HexAscii[W AND $F];
END;  { HexWordStr }

PROCEDURE LineNumber;
CONST
  BS = #8;
BEGIN
  INC(LineNum);
  IF LineNum = 1 THEN
    Write('Processing hex file line number:',LineNum:5)
  ELSE IF (LineNum AND $3F) = 0 THEN
    Write(BS+BS+BS+BS+BS,LineNum:5);
END;  { LineNumnber }

PROCEDURE LoadHex;
CONST
  Default: BYTE = $FF;
VAR
  A: WORD;
  T: TEXT;
  S: STRING;
  I, N, C, L, Index: INTEGER;
  CSum: BYTE;
  HadTermRec: BOOLEAN;

  FUNCTION HexNibble: BYTE;
  VAR
    B: Byte;
  BEGIN
    INC(Index);
    B := ORD(S[Index]) - $30;
    IF B > 9 THEN
      DEC(B, 7);
    IF (B AND $F0) <> 0 THEN BEGIN
      Writeln;
      Writeln('Hex file contains invalid character');
      Halt(1);
    END;
    HexNibble := B;
  END;  { HexNibble }

  FUNCTION HexByte: BYTE;
  VAR
    B: Byte;
  BEGIN
    B := HexNibble SHL 4;
    INC(B, HexNibble);
    INC(CSum, B);
    HexByte := B;
  END;  { HexByte }

  FUNCTION HexWord: WORD;
  VAR
    W: WORD;
  BEGIN
    W := HexByte SHL 8;
    W := W OR HexByte;
    HexWord := W;
  END;  { HexWord }

BEGIN
  IF (ParamCount > 3) AND (ParamStr(4) = '0') THEN
    Default := 0;
  IF ParamCount < 5 THEN
    HiBuff := 0
  ELSE BEGIN
    Val(ParamStr(5),I,N);
    HiBuff := I SHL 7;
  END;
  LoBuff := $FFFF;
  FOR A := 0 TO MaxBuff DO
    BBuff^[A] := Default;
  Assign(T, F1Name);
{$F-}
  Reset(T);
{$F+}
  IF IOresult <> 0 THEN BEGIN
    Writeln('Unable to open : ', F1Name);
    Halt(1);
  END;
  HadTermRec := FALSE;
  WHILE NOT (HadTermRec OR EOF(T)) DO BEGIN
    Readln(T, S);
    LineNumber;
    L := Length(S);
    IF (Length(S) > 10) AND (S[1] = ':') THEN BEGIN
      Index := 1;
      CSum := 0;
      N := HexByte;
      A := HexWord + Offset;
      C := HexByte;
      IF (L-11) <> (2*N) THEN BEGIN
        Writeln('Line Length Error');
        Halt(1);
      END;
      IF (C = 1) OR (N = 0) THEN
        HadTermRec := TRUE
      ELSE IF C = 0 THEN BEGIN
        IF A < LoBuff THEN
          LoBuff := A;
        FOR I := 1 TO N DO BEGIN
          BBuff^[A] := HexByte;
          INC(A);
          IF A > MaxBuff THEN BEGIN
            Writeln;
            Writeln('Hex Address too high in line ', LineNum);
            Halt(1);
          END;
        END;
        C := HexByte;                    { read checksum hex pair }
        IF CSum <> 0 THEN BEGIN
          Writeln;
          Writeln('Checksum error in line ', LineNum,'    ',CSum);
{         Halt(1);}
        END;
        IF A > HiBuff THEN
          HiBuff := A;
      END;
    END;
  END;
  Close(T);
  Writeln;
  IF ParamCount > 4 THEN BEGIN
    CheckSum := 0;
    FOR A := 0 TO HiBuff-1 DO
      Inc(CheckSum,BBuff^[A]);
    Writeln('Checksum ',HexWordStr(CheckSum));
  END;
  IF NOT HadTermRec THEN
    Writeln('Warning: Terminator record not found, hex file probably truncated.');
END;  { LoadHex }

PROCEDURE SaveHex(Limit: WORD; Width: INTEGER; IFormat: Boolean);
VAR
  I, Index, CurrentWidth: INTEGER;
  W, L2: WORD;
  CSum: BYTE;
  S: STRING;
  T: TEXT;

  PROCEDURE ByteHex(B:BYTE);
  BEGIN
    INC(Index);
    S[Index] := HexAscii[(B SHR 4) AND $F];
    INC(Index);
    S[Index] := HexAscii[B AND $F];
  END;  { ByteHex }

BEGIN
  Assign(T, F2Name);
  Rewrite(T);
  W := 0;
  CurrentWidth := Width;
  REPEAT
    L2 := Limit - W;
    IF L2 < CurrentWidth THEN
      CurrentWidth := L2;
    IF IFormat THEN BEGIN
      S := ':nnaaaa00';
      Index := 1;
      ByteHex(CurrentWidth);
      ByteHex(Hi(W+Offset));
      ByteHex(Lo(W+Offset));
      INC(Index, 2);
      CSum := CurrentWidth + Hi(W+Offset) + Lo(W+Offset);
      FOR I := 1 TO CurrentWidth DO BEGIN
        ByteHex(BBuff^[W]);
        INC(CSum, BBuff^[W]);
        INC(W);
      END;
      ByteHex(256-CSum);
    END ELSE BEGIN
      Index := 0;
      FOR I := 1 TO CurrentWidth DO BEGIN
        INC(Index);
        S[Index] := ' ';
        ByteHex(BBuff^[W]);
        INC(W);
      END;
    END;
    S[0] := CHR(Index);
    Writeln(T, S);
    LineNumber;
  UNTIL W >= Limit;
  IF IFormat THEN
    Writeln(T, ':00000001FF');
  Close(T);
END;  { SaveHex }

PROCEDURE LoadBin;
VAR
  F: FILE;
  S: STRING;
BEGIN
  IntelFormat := True;
  IF ParamCount < 4 THEN
    SaveHexWidth := 16
  ELSE BEGIN
    Val(ParamStr(4),SaveHexWidth,I);
    IF I <> 0 THEN
      SaveHexWidth := 16;
  END;
  IF ParamCount > 4 THEN BEGIN
    S := ParamStr(5);
    IF UpCase(S[1]) <> 'I' THEN
      IntelFormat := False;
  END;
  Assign(F, F1Name);
{$F-}
  Reset(F, 1);
{$F+}
  IF IOresult <> 0 THEN BEGIN
    Writeln('Unable to open : ', F1Name);
    Halt(1);
  END;
  BlockRead(F, BBuff^, MaxBuff+1, HiBuff);
  Close(F);
END;  { LoadBin }

PROCEDURE SaveBin;
VAR
  F: FILE;
BEGIN
  Writeln('Saving binary image of ', HiBuff, ' bytes to ', F2Name);
  Writeln('Code Area : ', HexWordStr(LoBuff),' to ',HexWordStr(HiBuff-1));
  Assign(F, F2Name);
  Rewrite(F, 1);
  BlockWrite(F, BBuff^, HiBuff);
  Close(F);
END;  { SaveBin }

PROCEDURE Help;
BEGIN
  Writeln;
  Writeln('INTEL hex <-> binary file converter');
  Writeln;
  Writeln('Usage: HEXBIN inhexfile outfile [offset] [0] [Eprom type (27xx)]');
  Writeln('   or  HEXBIN infile outhexfile [offset] [width] [format]');
  Writeln;
  Writeln('Either infile or outfile must have .HEX extension');
  Writeln;
  Writeln('If infile  has .HEX extension, HEX to binary conversion is performed');
  Writeln('If outfile has .HEX extension, binary to HEX conversion is performed');
  Writeln;
  Writeln('For HEX to binary conversion, default code is 0FFh unless 0 is specified');
  Writeln;
  Writeln('For binary to HEX conversion, Intel format unless format <> I');
  Halt(1);
END;  { Help }

BEGIN
  Writeln('Hex/Bin Utility by B Whitnall, v 1.3');
  IF ParamCount < 2 THEN
    Help;
  F1Name := ParamStr(1);
  F2Name := ParamStr(2);
  IF ParamCount = 2 THEN
    Offset := 0
  ELSE BEGIN
    OffsetStr := ParamStr(3);
    Negative := (OffsetStr[1] = '-');
    IF Negative THEN
      Delete(OffsetStr, 1, 1);
    IF OffsetStr[1] <> '$' THEN
      OffsetStr := '$' + OffsetStr;
    I := Length(OffsetStr);
    IF UpCase(OffsetStr[I]) = 'H' THEN
      Delete(OffsetStr, I, 1);
    Val(OffsetStr, Offset, I);
    IF Negative THEN
      Offset := $FFFF - Offset + 1;
  END;
  UpString(F1Name);
  UpString(F2Name);
  NEW(BBuff);
  LineNum := 0;
  ToHex := (POS('.HEX', F2Name) <> 0);
  IF NOT ToHex AND (POS('.HEX', F1Name) = 0) THEN
    Help;
  Writeln('Converting: ', F1Name, ' -> ', F2Name);
  IF ToHex THEN BEGIN
    LoadBin;
    SaveHex(HiBuff, SaveHexWidth, IntelFormat);
  END ELSE  BEGIN
    LoadHex;
    SaveBin;
  END;
END.
